/*
 * Decompiled with CFR 0.152.
 */
package jexifviewer;

import java.util.Comparator;
import java.util.Date;
import jexifviewer.JExifDataModel;
import jexifviewer.JIfdData;
import shared.table.JTableColSortData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JExifDataComparator
implements Comparator<JIfdData> {
    private JTableColSortData[] m_sortData;
    private int m_index = 0;

    public JExifDataComparator(JTableColSortData[] jTableColSortDataArray) {
        this.m_sortData = jTableColSortDataArray;
    }

    @Override
    public int compare(JIfdData jIfdData, JIfdData jIfdData2) {
        int n = 0;
        switch (JExifDataModel.m_colTag[this.m_sortData[this.m_index].getSortCol()]) {
            case 0: {
                n = jIfdData.getFileName().compareTo(jIfdData2.getFileName());
                break;
            }
            case 271: {
                n = jIfdData.getMake().compareTo(jIfdData2.getMake());
                break;
            }
            case 270: {
                n = jIfdData.getDescription().compareTo(jIfdData2.getDescription());
                break;
            }
            case 272: {
                n = jIfdData.getModel().compareTo(jIfdData2.getModel());
                break;
            }
            case 274: {
                n = jIfdData.getOrientation() - jIfdData2.getOrientation();
                break;
            }
            case 2: {
                double d = 1.0;
                if (jIfdData.getResolutionUnit() != jIfdData2.getResolutionUnit()) {
                    double d2 = d = jIfdData.getResolutionUnit() == 2 ? 6.4516 : 0.15500031000062;
                }
                if ((d = (double)(jIfdData.getXResolution() * jIfdData.getYResolution()) * d - (double)(jIfdData2.getXResolution() * jIfdData2.getYResolution())) < 0.0) {
                    n = -1;
                    break;
                }
                if (d > 0.0) {
                    n = 1;
                    break;
                }
                n = 0;
                break;
            }
            case 305: {
                n = jIfdData.getSoftware().compareTo(jIfdData2.getSoftware());
                break;
            }
            case 306: {
                n = jIfdData.getChangeDateTime().compareTo(jIfdData2.getChangeDateTime());
                break;
            }
            case 315: {
                n = jIfdData.getArtist().compareTo(jIfdData2.getArtist());
                break;
            }
            case 531: {
                n = jIfdData.getYCbCrPosition() - jIfdData2.getYCbCrPosition();
                break;
            }
            case 33432: {
                n = jIfdData.getCopyright().compareTo(jIfdData2.getCopyright());
                break;
            }
            case 33434: {
                n = jIfdData.getExposureTime(null) - jIfdData2.getExposureTime(null);
                break;
            }
            case 33437: {
                double d = jIfdData.getFNumber(null) - jIfdData2.getFNumber(null);
                if (d < 0.0) {
                    n = -1;
                    break;
                }
                if (d > 0.0) {
                    n = 1;
                    break;
                }
                n = 0;
                break;
            }
            case 34850: {
                n = jIfdData.getExposureProgram() - jIfdData2.getExposureProgram();
                break;
            }
            case 34855: {
                n = jIfdData.getISOSpeedRatings() - jIfdData2.getISOSpeedRatings();
                break;
            }
            case 36864: {
                n = jIfdData.getExifVersion().compareTo(jIfdData2.getExifVersion());
                break;
            }
            case 36867: {
                n = jIfdData.getOriginalDateTime().compareTo(jIfdData2.getOriginalDateTime());
                break;
            }
            case 36868: {
                n = jIfdData.getDigitizedDateTime().compareTo(jIfdData2.getDigitizedDateTime());
                break;
            }
            case 37121: {
                n = jIfdData.getComponentsConfig().compareTo(jIfdData2.getComponentsConfig());
                break;
            }
            case 37122: {
                double d = jIfdData.getCompressedBitsPerPixel() - jIfdData2.getCompressedBitsPerPixel();
                if (d < 0.0) {
                    n = -1;
                    break;
                }
                if (d > 0.0) {
                    n = 1;
                    break;
                }
                n = 0;
                break;
            }
            case 37377: {
                double d = jIfdData.getShuterSpeedValue() - jIfdData2.getShuterSpeedValue();
                if (d < 0.0) {
                    n = -1;
                    break;
                }
                if (d > 0.0) {
                    n = 1;
                    break;
                }
                n = 0;
                break;
            }
            case 37378: {
                double d = jIfdData.getApertureValue() - jIfdData2.getApertureValue();
                if (d < 0.0) {
                    n = -1;
                    break;
                }
                if (d > 0.0) {
                    n = 1;
                    break;
                }
                n = 0;
                break;
            }
            case 37379: {
                double d = jIfdData.getBrightnessValue() - jIfdData2.getBrightnessValue();
                if (d < 0.0) {
                    n = -1;
                    break;
                }
                if (d > 0.0) {
                    n = 1;
                    break;
                }
                n = 0;
                break;
            }
            case 37380: {
                double d = jIfdData.getExposureBiasValue() - jIfdData2.getExposureBiasValue();
                if (d < 0.0) {
                    n = -1;
                    break;
                }
                if (d > 0.0) {
                    n = 1;
                    break;
                }
                n = 0;
                break;
            }
            case 37381: {
                double d = jIfdData.getMaxApertureValue() - jIfdData2.getMaxApertureValue();
                if (d < 0.0) {
                    n = -1;
                    break;
                }
                if (d > 0.0) {
                    n = 1;
                    break;
                }
                n = 0;
                break;
            }
            case 37383: {
                n = jIfdData.getMeteringMode() - jIfdData2.getMeteringMode();
                break;
            }
            case 37384: {
                n = jIfdData.getLightSource() - jIfdData2.getLightSource();
                break;
            }
            case 37385: {
                n = jIfdData.getFlash() - jIfdData2.getFlash();
                break;
            }
            case 37386: {
                double d = jIfdData.getFocalLength() - jIfdData2.getFocalLength();
                if (d < 0.0) {
                    n = -1;
                    break;
                }
                if (d > 0.0) {
                    n = 1;
                    break;
                }
                n = 0;
                break;
            }
            case 40961: {
                n = jIfdData.getColorSpace() - jIfdData2.getColorSpace();
                break;
            }
            case 1: {
                double d = jIfdData.getPixelXDimension() * jIfdData.getPixelYDimension() - jIfdData2.getPixelXDimension() * jIfdData2.getPixelYDimension();
                if (d < 0.0) {
                    n = -1;
                    break;
                }
                if (d > 0.0) {
                    n = 1;
                    break;
                }
                n = 0;
                break;
            }
            case 3: {
                double d = 1.0;
                if (jIfdData.getFocalPlaneResolutionUnit() != jIfdData2.getFocalPlaneResolutionUnit()) {
                    double d3 = d = jIfdData.getResolutionUnit() == 2 ? 6.4516 : 0.15500031000062;
                }
                if ((d = (double)(jIfdData.getFocalPlaneXResolution() * jIfdData.getFocalPlaneYResolution()) * d - (double)(jIfdData2.getFocalPlaneXResolution() * jIfdData2.getFocalPlaneYResolution())) < 0.0) {
                    n = -1;
                    break;
                }
                if (d > 0.0) {
                    n = 1;
                    break;
                }
                n = 0;
                break;
            }
            case 41495: {
                n = jIfdData.getSensingMode() - jIfdData2.getSensingMode();
                break;
            }
            case 41985: {
                n = jIfdData.getCustomRendered() - jIfdData2.getCustomRendered();
                break;
            }
            case 41986: {
                n = jIfdData.getExposureMode() - jIfdData2.getExposureMode();
                break;
            }
            case 41987: {
                n = jIfdData.getWhiteBalance() - jIfdData2.getWhiteBalance();
                break;
            }
            case 41988: {
                double d = jIfdData.getDigitalZoomRatio() - jIfdData2.getDigitalZoomRatio();
                if (d < 0.0) {
                    n = -1;
                    break;
                }
                if (d > 0.0) {
                    n = 1;
                    break;
                }
                n = 0;
                break;
            }
            case 41989: {
                n = jIfdData.getFocalLength35mm() - jIfdData2.getFocalLength35mm();
                break;
            }
            case 41990: {
                n = jIfdData.getSceneCaptureType() - jIfdData2.getSceneCaptureType();
                break;
            }
            case 41729: {
                n = jIfdData.getSceneType() - jIfdData2.getSceneType();
                break;
            }
            case 41991: {
                n = jIfdData.getGainControl() - jIfdData2.getGainControl();
                break;
            }
            case 41992: {
                n = jIfdData.getContrast() - jIfdData2.getContrast();
                break;
            }
            case 41993: {
                n = jIfdData.getSaturation() - jIfdData2.getSaturation();
                break;
            }
            case 41994: {
                n = jIfdData.getSharpness() - jIfdData2.getSharpness();
                break;
            }
            case 41996: {
                n = jIfdData.getSubjectDistanceRange() - jIfdData2.getSubjectDistanceRange();
                break;
            }
            case 4: {
                n = (int)(jIfdData.getFileSize() - jIfdData2.getFileSize());
                break;
            }
            case 5: {
                n = jIfdData.getFileDate().compareTo(jIfdData2.getFileDate());
                break;
            }
            case 41728: {
                n = jIfdData.getFileSource() - jIfdData2.getFileSource();
                break;
            }
            case 65536: {
                n = jIfdData.getGPSVersionID().compareTo(jIfdData2.getGPSVersionID());
                break;
            }
            case 65538: {
                double d = jIfdData.getGPSLatitude() * (float)(jIfdData.getGPSLatitudeRef().equals("N") ? 1 : -1);
                double d4 = jIfdData2.getGPSLatitude() * (float)(jIfdData2.getGPSLatitudeRef().equals("N") ? 1 : -1);
                double d5 = d - d4;
                if (d5 < 0.0) {
                    n = -1;
                    break;
                }
                if (d5 > 0.0) {
                    n = 1;
                    break;
                }
                n = 0;
                break;
            }
            case 65540: {
                double d = jIfdData.getGPSLongitude() * (float)(jIfdData.getGPSLongitudeRef().equals("E") ? 1 : -1);
                double d6 = jIfdData2.getGPSLongitude() * (float)(jIfdData2.getGPSLongitudeRef().equals("E") ? 1 : -1);
                double d7 = d - d6;
                if (d7 < 0.0) {
                    n = -1;
                    break;
                }
                if (d7 > 0.0) {
                    n = 1;
                    break;
                }
                n = 0;
                break;
            }
            case 65542: {
                double d = jIfdData.getGPSAltitude() * (float)(jIfdData.getGPSAltitudeRef() > 0 ? -1 : 1);
                double d8 = jIfdData2.getGPSAltitude() * (float)(jIfdData2.getGPSAltitudeRef() > 0 ? -1 : 1);
                double d9 = d - d8;
                if (d9 < 0.0) {
                    n = -1;
                    break;
                }
                if (d9 > 0.0) {
                    n = 1;
                    break;
                }
                n = 0;
                break;
            }
            case 65543: {
                long l;
                long l2;
                Date date = jIfdData.getGPSTimestamp();
                Date date2 = jIfdData2.getGPSTimestamp();
                n = date != null && date2 != null ? ((l2 = date.getTime()) < (l = date2.getTime()) ? -1 : (l2 > l ? 1 : 0)) : (date != null ? -1 : (date2 != null ? 1 : 0));
                double d = jIfdData2.getGPSAltitude() * (float)(jIfdData2.getGPSAltitudeRef() > 0 ? -1 : 1);
            }
            case 65544: {
                n = jIfdData.getGPSSatellites().compareTo(jIfdData2.getGPSSatellites());
                break;
            }
            case 65545: {
                n = jIfdData.getGPSStatus().compareTo(jIfdData2.getGPSStatus());
                break;
            }
            case 65546: {
                n = jIfdData.getGPSMeasureMode().compareTo(jIfdData2.getGPSMeasureMode());
                break;
            }
            case 69632: {
                if (jIfdData.isTagPresent(69632) && !jIfdData2.isTagPresent(69632)) {
                    n = 1;
                    break;
                }
                if (jIfdData.isTagPresent(69632) || !jIfdData2.isTagPresent(69632)) break;
                n = -1;
            }
        }
        if (n == 0) {
            if (++this.m_index < this.m_sortData.length) {
                n = this.compare(jIfdData, jIfdData2);
            }
            --this.m_index;
        } else if (!this.m_sortData[this.m_index].getSortUp()) {
            n = -n;
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof JExifDataComparator) {
            JExifDataComparator jExifDataComparator = (JExifDataComparator)object;
            if (jExifDataComparator.m_sortData.equals(jExifDataComparator.m_sortData)) {
                bl = true;
            }
        }
        return bl;
    }
}

